<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
        $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : null;

        // Initialize the SQL query for follow_up
        $sql = "
        SELECT 
            follow_up.*, 
            users.username 
        FROM 
            follow_up 
        INNER JOIN 
            users 
                ON users.id = follow_up.user_id";
        $params = [];

        // Add conditions based on the provided query parameters
        if ($id !== null) {
            $sql .= " WHERE user_id = $id";
        }

        // Add date filtering if start_date and end_date are provided
        if ($start_date !== null && $end_date !== null) {
            $sql .= ($id !== null) ? " AND" : " WHERE";
            $sql .= " DATE(next_followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date')";
        }

        $sql .= " ORDER BY DATE(followup_date) DESC";
        
        $stmt = $conn->prepare($sql);        
        // Execute the statement
        $stmt->execute();
        $follow_up_records = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Count follow-ups without previous records
        $sql_count_first = "
        SELECT COUNT(*) AS first_followups 
        FROM follow_up f1 
        WHERE NOT EXISTS (
            SELECT 1 FROM follow_up f2 
            WHERE f1.enquiry_id = f2.enquiry_id 
            AND f1.followup_date > f2.followup_date
        ) AND DATE(next_followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date')";
        $stmt_first = $conn->prepare($sql_count_first);
        $stmt_first->execute();
        $first_followups = $stmt_first->fetch(PDO::FETCH_ASSOC)['first_followups'];

        // Count follow-ups with previous records
        $sql_count_followups = "
        SELECT COUNT(*) AS repeated_followups 
        FROM follow_up f1 
        WHERE EXISTS (
            SELECT 1 FROM follow_up f2 
            WHERE f1.enquiry_id = f2.enquiry_id 
            AND f1.followup_date > f2.followup_date
        ) AND DATE(next_followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date')";
        $stmt_repeated = $conn->prepare($sql_count_followups);
        $stmt_repeated->execute();
        $repeated_followups = $stmt_repeated->fetch(PDO::FETCH_ASSOC)['repeated_followups'];

        if (count($follow_up_records) > 0) {
            $response = [
                "success" => true,
                "data" => $follow_up_records,
                "first_followups" => $first_followups,
                "repeated_followups" => $repeated_followups
            ];
        } else {
            $response = [
                "success" => true,
                "message" => "No records found",
                "first_followups" => $first_followups,
                "repeated_followups" => $repeated_followups
            ];
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Unknown error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
