<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['user_id']) && isset($data['kpi_id']) && isset($data['weight'])) {
            $userId = $data['user_id'];
            $kpi_id = $data['kpi_id'];
            $weight = $data['weight'];
            // Prepare SQL query
            $sql = "DELETE FROM  user_kpis_manual_relation WHERE user_id = $userId AND kpi_id = $kpi_id";
            $stmt = $conn->prepare($sql);
            $stmt->execute();

            $sql = "INSERT INTO user_kpis_manual_relation (user_id, kpi_id, weight) VALUES (:user_id, :kpi_id, :weight)";
            $stmt = $conn->prepare($sql);

            // Bind parameters
            $stmt->bindParam(':user_id', $userId);
            $stmt->bindParam(':kpi_id', $kpi_id);
            $stmt->bindParam(':weight', $weight);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Fields Missing");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
