<?php
header('Content-Type: application/json');
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $id = isset($_GET['office_id']) ? $_GET['office_id'] : null;

        if ($id === null) {
            throw new Exception("Office ID is required");
        }

        // Prepare SQL query using prepared statements
        $sql = "SELECT * FROM office WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
