-- MySQL dump 10.13  Distrib 8.0.40, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: dev_crm
-- ------------------------------------------------------
-- Server version	8.0.40

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `assign_enquiries`
--

DROP TABLE IF EXISTS `assign_enquiries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assign_enquiries` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `enquiry_id` int NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assign_enquiries`
--

LOCK TABLES `assign_enquiries` WRITE;
/*!40000 ALTER TABLE `assign_enquiries` DISABLE KEYS */;
INSERT INTO `assign_enquiries` VALUES (1,28,1,1,'2024-12-06 15:28:01'),(2,28,2,1,'2024-12-09 11:28:49'),(3,28,3,1,'2024-12-09 12:57:37'),(4,28,4,1,'2024-12-09 13:05:21'),(5,28,5,1,'2024-12-09 13:09:13'),(6,28,6,1,'2024-12-09 13:27:24');
/*!40000 ALTER TABLE `assign_enquiries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_level_four`
--

DROP TABLE IF EXISTS `category_level_four`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_level_four` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_level_three_id` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_level_three_id` (`category_level_three_id`),
  CONSTRAINT `category_level_four_ibfk_1` FOREIGN KEY (`category_level_three_id`) REFERENCES `category_level_three` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_level_four`
--

LOCK TABLES `category_level_four` WRITE;
/*!40000 ALTER TABLE `category_level_four` DISABLE KEYS */;
INSERT INTO `category_level_four` VALUES (15,14,'October 2024'),(19,19,'December 2024'),(20,20,'November 2024'),(21,21,'October 2024'),(22,22,'October 2024'),(23,23,'September 2024'),(24,24,'September 2024'),(25,25,'December 2024');
/*!40000 ALTER TABLE `category_level_four` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_level_one`
--

DROP TABLE IF EXISTS `category_level_one`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_level_one` (
  `id` int NOT NULL AUTO_INCREMENT,
  `office_id` int DEFAULT NULL,
  `organization_id` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `organization_id` (`organization_id`),
  KEY `office_id` (`office_id`),
  CONSTRAINT `category_level_one_ibfk_1` FOREIGN KEY (`organization_id`) REFERENCES `organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `category_level_one_ibfk_2` FOREIGN KEY (`office_id`) REFERENCES `office` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_level_one`
--

LOCK TABLES `category_level_one` WRITE;
/*!40000 ALTER TABLE `category_level_one` DISABLE KEYS */;
INSERT INTO `category_level_one` VALUES (21,18,NULL,'Energy System'),(27,20,NULL,'Audit');
/*!40000 ALTER TABLE `category_level_one` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_level_three`
--

DROP TABLE IF EXISTS `category_level_three`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_level_three` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_level_two_id` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_level_two_id` (`category_level_two_id`),
  CONSTRAINT `category_level_three_ibfk_1` FOREIGN KEY (`category_level_two_id`) REFERENCES `category_level_two` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_level_three`
--

LOCK TABLES `category_level_three` WRITE;
/*!40000 ALTER TABLE `category_level_three` DISABLE KEYS */;
INSERT INTO `category_level_three` VALUES (14,17,'Level 3 Diploma in Accounting and Finance'),(19,22,'Level 7 Diploma in Business Management'),(20,23,'Level 5 Diploma in Health and Social Care Management'),(21,24,'Level 7 Diploma in Information Technology'),(22,25,'Level 5 Diploma in Law'),(23,26,'Level 8 Diploma in Strategic Management and Leadership'),(24,28,'Level 7 Diploma in Leadership'),(25,29,'Level 3 Diploma Foundation in Social Care');
/*!40000 ALTER TABLE `category_level_three` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_level_two`
--

DROP TABLE IF EXISTS `category_level_two`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_level_two` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_level_one_id` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_level_one_id` (`category_level_one_id`),
  CONSTRAINT `category_level_two_ibfk_1` FOREIGN KEY (`category_level_one_id`) REFERENCES `category_level_one` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_level_two`
--

LOCK TABLES `category_level_two` WRITE;
/*!40000 ALTER TABLE `category_level_two` DISABLE KEYS */;
INSERT INTO `category_level_two` VALUES (17,21,'Accounting and Finance'),(22,27,'Business Management'),(23,27,'Health and Social Care'),(24,21,'Information Systems'),(25,21,'Legal Studies'),(26,21,'Business Studies'),(28,27,'Leadership Studies'),(29,27,'Social Care');
/*!40000 ALTER TABLE `category_level_two` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `complaint_bd`
--

DROP TABLE IF EXISTS `complaint_bd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `complaint_bd` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_id` int DEFAULT NULL,
  `to_user` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `type_of` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_request` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `complaint_bd`
--

LOCK TABLES `complaint_bd` WRITE;
/*!40000 ALTER TABLE `complaint_bd` DISABLE KEYS */;
/*!40000 ALTER TABLE `complaint_bd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_kpis`
--

DROP TABLE IF EXISTS `config_kpis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_kpis` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kpi_name` varchar(255) DEFAULT NULL,
  `description_kpis` varchar(500) DEFAULT NULL,
  `on_report` tinyint(1) DEFAULT '0',
  `report_name` varchar(500) DEFAULT NULL,
  `type_of_kpi` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_kpis`
--

LOCK TABLES `config_kpis` WRITE;
/*!40000 ALTER TABLE `config_kpis` DISABLE KEYS */;
INSERT INTO `config_kpis` VALUES (1,'CRM Utilization Rate','Measures how effectively the BDE/TSE utilizes CRM tools to manage leads, track interactions, and update client information.',0,'CRM Utilization','Judgement Based'),(2,'Lead Conversion Rate','Account Growth and Management. Percentage of leads successfully converted into paying clients',1,'Lead Conversion','System Based'),(3,'Avg. Sales Cycle','Average time from initial contact to deal closure, with an aim to reduce it',1,'Sales Cycle Length','System Based'),(4,'Follow-up Efficiency','Tracks the speed and effectiveness of follow-ups on leads and client inquiries, impacting conversion and retention. Lead Management and Pipeline Progression. Measures the number of leads in each sales funnel stage, helping balance outreach efforts and ensure a steady flow of conversions',1,'Follow-up Efficiency','System Based'),(5,'Quotation Conversion Rate','Comparing forecasted sales to actual sales to ensure alignment and improve planning accuracy',1,'Quotation Conversion','System Based'),(6,'Client Meetings','Measure ASM’s effectiveness in growing market share within the assigned area recode meetings in CRM.',1,'Client Meetings','System Based'),(8,'Partners/ Dist. Onboarding','Tracks the number of new partnerships or distribution channels established to expand sales reach.',1,'Partners/ Dist. Onboarding','System Based'),(9,'Client Training/ Awareness','Number of product demos, training sessions, or awareness events conducted.',1,'Client Training/ Awareness','System Based'),(10,'Calls Made','Tracks the daily or weekly number of outbound calls each representative makes.',1,'Calls Made','System Based'),(11,'Avg. Talk Time per Call','Measures the average duration of calls, helping assess call quality and engagement.',1,'Avg. Talk Time per Call','System Based'),(12,'Qualifying Leads','Number of leads deemed qualified after initial calls Lead Management and Pipeline Progression.',1,'Qualifying Leads','System Based'),(13,'Appointments-to-Leads Ratio','Tracks how many calls result in an appointment or follow-up meeting, signaling the tele-sales team’s success in progressing the sales pipeline',1,'Appointments-to-Leads','System Based'),(14,'Ineffective Calls Rate','Percentage of unanswered calls or dropped calls, important for maximizing contact attempts',1,'Ineffective Calls Rate','System Based'),(15,'Avg. Deal Size','Measures the average revenue per conversion, reflecting the team\'s ability to upsell or cross-sell effectively',1,'Avg. Deal Size','System Based'),(16,'Brand Visibility','Increase in brand mentions, inquiries, or engagement metrics in the regione client information.',0,'Brand Visibility','Judgement Based');
/*!40000 ALTER TABLE `config_kpis` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_kpis_role`
--

DROP TABLE IF EXISTS `config_kpis_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_kpis_role` (
  `id` int NOT NULL AUTO_INCREMENT,
  `weight` int DEFAULT NULL,
  `kpi_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_kpis_role`
--

LOCK TABLES `config_kpis_role` WRITE;
/*!40000 ALTER TABLE `config_kpis_role` DISABLE KEYS */;
INSERT INTO `config_kpis_role` VALUES (1,10,1,10),(2,10,2,10),(3,50,1,12),(4,10,2,12),(5,5,1,25),(6,15,2,25),(7,10,3,25),(8,10,4,25),(9,5,5,25),(10,20,6,25),(11,10,8,25),(12,15,9,25),(13,10,10,25);
/*!40000 ALTER TABLE `config_kpis_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_kpis_role_table`
--

DROP TABLE IF EXISTS `config_kpis_role_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_kpis_role_table` (
  `id` int NOT NULL AUTO_INCREMENT,
  `start_range` int DEFAULT NULL,
  `end_range` int DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `kpi_role_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_kpis_role_table`
--

LOCK TABLES `config_kpis_role_table` WRITE;
/*!40000 ALTER TABLE `config_kpis_role_table` DISABLE KEYS */;
INSERT INTO `config_kpis_role_table` VALUES (1,1,1,1,2,10),(3,1,1,11,4,12);
/*!40000 ALTER TABLE `config_kpis_role_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enquiries`
--

DROP TABLE IF EXISTS `enquiries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `enquiries` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_by` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `enquiry_entered_by` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `income_range` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `enquiry_date` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `username` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `cnic` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `date_of_birth` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `email` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `father_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `gender` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `present_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `permanent_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `mobile_no_one` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `mobile_no_two` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `landline` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `project` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `product` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `developer` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `price_offered` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `property_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `source_of_information` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `enquiry_status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_one` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_two` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_three` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_four` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_five` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_six` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_seven` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_eight` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_nine` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_ten` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_eleven` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_twelve` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_thirteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_fourteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_fifteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_sixteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_seventeen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_eighteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_nineteen` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `field_twenty` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `office_id` int DEFAULT NULL,
  `matured` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `cat_one_id` int DEFAULT NULL,
  `cat_two_id` int DEFAULT NULL,
  `cat_three_id` int DEFAULT NULL,
  `cat_four_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `enquiry_status_steps` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `enquiry_matured_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `office_id` (`office_id`),
  KEY `cat_one_id` (`cat_one_id`),
  KEY `cat_two_id` (`cat_two_id`),
  KEY `cat_three_id` (`cat_three_id`),
  KEY `cat_four_id` (`cat_four_id`),
  CONSTRAINT `enquiries_ibfk_1` FOREIGN KEY (`office_id`) REFERENCES `office` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiries_ibfk_2` FOREIGN KEY (`cat_one_id`) REFERENCES `category_level_one` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiries_ibfk_3` FOREIGN KEY (`cat_two_id`) REFERENCES `category_level_two` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiries_ibfk_4` FOREIGN KEY (`cat_three_id`) REFERENCES `category_level_three` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiries_ibfk_5` FOREIGN KEY (`cat_four_id`) REFERENCES `category_level_four` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enquiries`
--

LOCK TABLES `enquiries` WRITE;
/*!40000 ALTER TABLE `enquiries` DISABLE KEYS */;
INSERT INTO `enquiries` VALUES (1,NULL,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Afghanistan',NULL,NULL,NULL,'A',NULL,'Follow-up Required',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'0',21,NULL,NULL,NULL,'2024-12-06 10:28:01','Lead Matured','2024-12-07'),(2,NULL,'A',NULL,NULL,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'0',21,NULL,NULL,NULL,'2024-12-09 06:28:49','Negotiation','2024-12-09'),(3,NULL,NULL,NULL,NULL,'Adnan',NULL,NULL,NULL,'Ahmad','Male',NULL,NULL,NULL,'03224547810',NULL,NULL,NULL,'Pakistan',NULL,NULL,NULL,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'0',21,NULL,NULL,NULL,'2024-12-09 07:57:37','Lead Capturing',NULL),(4,'admin',NULL,NULL,NULL,'a',NULL,NULL,NULL,'a','Male',NULL,NULL,NULL,'1',NULL,NULL,NULL,'Andorra',NULL,NULL,NULL,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'0',21,NULL,NULL,NULL,'2024-12-09 08:05:21','Lead Capturing',NULL),(5,'Admission Officer',NULL,NULL,NULL,'Haroon',NULL,NULL,NULL,'Qadir','Male',NULL,NULL,NULL,'03244648426',NULL,NULL,NULL,'Pakistan',NULL,NULL,NULL,'A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Bilal Ahmad',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'0',21,NULL,NULL,NULL,'2024-12-09 08:09:13','Lead Capturing',NULL),(6,'LAP Centre',NULL,NULL,NULL,'Muhammad',NULL,NULL,NULL,'Faisal','Male',NULL,NULL,NULL,'0304490775',NULL,NULL,NULL,'Pakistan',NULL,NULL,NULL,'A',NULL,'Follow-up Required',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Ameer Farooq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20,'0',27,NULL,NULL,NULL,'2024-12-09 08:27:24','Lead Capturing',NULL);
/*!40000 ALTER TABLE `enquiries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enquiry_fields`
--

DROP TABLE IF EXISTS `enquiry_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `enquiry_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `field_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `type` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `show_field` tinyint(1) NOT NULL DEFAULT '0',
  `report_show` tinyint NOT NULL DEFAULT '0',
  `order_no` int DEFAULT '0',
  `required` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enquiry_fields`
--

LOCK TABLES `enquiry_fields` WRITE;
/*!40000 ALTER TABLE `enquiry_fields` DISABLE KEYS */;
INSERT INTO `enquiry_fields` VALUES (1,'Lead Entered By','enquiry_by',1,'Drop Down',1,0,5,0),(2,'Cosmetics','enquiry_entered_by',0,'Text',1,0,10,1),(4,'Income Range (GBP)','income_range',0,'Drop Down',1,0,140,0),(5,'Visa Status','enquiry_date',0,'Drop Down',1,1,190,0),(6,'First Name','username',1,'Text',1,1,30,1),(7,'Middle Name','cnic',0,'Text',1,0,40,0),(8,'Date of Birth','date_of_birth',0,'Date',1,0,150,0),(9,'Email','email',0,'Text',1,0,100,0),(10,'Last Name','father_name',1,'Text',1,1,50,0),(11,'Gender','gender',1,'Drop Down',1,0,60,0),(12,'City','city',0,'Text',1,0,130,0),(13,'Present Address','present_address',0,'Text',1,0,120,0),(14,'Permanent Address','permanent_address',0,'Text',1,0,110,0),(15,'Mobile No. ','mobile_no_one',1,'Number',1,1,70,0),(16,'Mobile No. (secondary)','mobile_no_two',0,'Number',1,0,80,0),(17,'Landline','landline',0,'Number',1,0,90,0),(18,'Birth Country','project',0,'Drop Down',1,0,200,0),(19,'Nationality','product',1,'Text',1,0,210,0),(20,'Ethnic Origin','developer',0,'Drop Down',1,0,220,0),(21,'Course Fee (GBP)','price_offered',0,'Number',1,0,160,0),(22,'Religion','property_address',0,'Drop Down',1,0,230,0),(23,'Sexual Orientation','image',1,'Drop Down',1,0,240,0),(24,'Hear About us','source_of_information',0,'Drop Down',1,0,170,0),(25,'Passport Issue','enquiry_status',0,'Date',1,0,350,0),(26,'Criminal Conviction','remarks',0,'Drop Down',1,1,180,0),(27,'Course Title','field_one',0,'Drop Down',1,0,250,0),(28,'Intake','field_two',0,'Drop Down',1,0,260,0),(29,'Year','field_three',0,'Drop Down',1,0,270,0),(30,'Course Start Date','field_four',0,'Date',0,1,280,0),(31,'Course End Date','field_five',0,'Date',1,0,290,0),(32,'Place of Study/Campus','field_six',0,'Drop Down',1,0,300,0),(33,'Visa Required','field_seven',0,'Drop Down',1,0,310,0),(34,'Visa Valid From','field_eight',0,'Date',1,0,320,0),(35,'Visa Expiry','field_nine',0,'Date',1,0,330,0),(36,'Passport No.','field_ten',0,'Text',1,0,340,0),(37,'Lead Generated By','field_eleven',1,'Text',1,0,360,0),(38,'Contact','field_twelve',0,'Text',1,0,370,0),(39,'field_thirteen','field_thirteen',0,'Text',1,0,380,0),(40,'field_fourteen','field_fourteen',0,'Text',1,0,390,0),(41,'field_fifteen','field_fifteen',0,'Text',1,0,400,0),(42,'field_sixteen','field_sixteen',0,'Text',1,0,410,0),(43,'field_seventeen','field_seventeen',0,'Text',1,0,420,0),(44,'field_eighteen','field_eighteen',0,'Text',1,0,430,0),(45,'field_nineteen','field_nineteen',0,'Text',1,0,440,0),(46,'field_twenty','field_twenty',0,'Text',1,0,450,0);
/*!40000 ALTER TABLE `enquiry_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enquiry_fields_dropdown`
--

DROP TABLE IF EXISTS `enquiry_fields_dropdown`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `enquiry_fields_dropdown` (
  `id` int NOT NULL AUTO_INCREMENT,
  `dropdown` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `field_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enquiry_fields_dropdown`
--

LOCK TABLES `enquiry_fields_dropdown` WRITE;
/*!40000 ALTER TABLE `enquiry_fields_dropdown` DISABLE KEYS */;
INSERT INTO `enquiry_fields_dropdown` VALUES (12,'Admission Officer','enquiry_by'),(13,'LAP Centre','enquiry_by'),(14,'Data Entry operator 1','enquiry_entered_by'),(15,'Data Entry operator 2','enquiry_entered_by'),(20,'10,000 - 20,000','income_range'),(21,'20,000 - 30,000','income_range'),(22,'30,000 - 40,000','income_range'),(25,'Social Media','source_of_information'),(26,'Friend & Family Members','source_of_information'),(30,'Matured','enquiry_status'),(31,'Dropped','enquiry_status'),(32,'Follow-up Required','enquiry_status'),(38,'Pakistan','project'),(39,'Pakistan','product'),(40,'Yes','field_seven'),(41,'No','field_seven'),(42,'Granted','enquiry_date'),(43,'Rejected','enquiry_date'),(44,'Pending','enquiry_date'),(45,'Male','gender'),(46,'Female','gender'),(47,'Prefer not to say','gender'),(48,'Islam','property_address'),(49,'Test Field 1','remarks'),(50,'Test Field 2','remarks'),(51,'Test Field 1','developer'),(52,'Test Field 2','developer'),(55,'Test course 1','field_one'),(56,'Test course 2','field_one'),(57,'Test intake 1','field_two'),(58,'Test intake 2','field_two'),(59,'2024','field_three'),(60,'2025','field_three'),(61,'Town ship','field_six'),(62,'Model Town','field_six'),(82,'A','image \r\n'),(83,'B','image \r\n'),(84,'A','image');
/*!40000 ALTER TABLE `enquiry_fields_dropdown` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enquiry_images`
--

DROP TABLE IF EXISTS `enquiry_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `enquiry_images` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image_path` text,
  `title` text,
  `enquiry_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enquiry_images`
--

LOCK TABLES `enquiry_images` WRITE;
/*!40000 ALTER TABLE `enquiry_images` DISABLE KEYS */;
INSERT INTO `enquiry_images` VALUES (1,'6756a2f1ad578_281-200x300.jpg','My Doc',3),(2,'6756a5a99d0f3_116-200x300.jpg','My Doc',5),(3,'6756a9ecb25a0_116-200x300.jpg','New Doc',6);
/*!40000 ALTER TABLE `enquiry_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enquiry_products`
--

DROP TABLE IF EXISTS `enquiry_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `enquiry_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_id` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enquiry_products`
--

LOCK TABLES `enquiry_products` WRITE;
/*!40000 ALTER TABLE `enquiry_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `enquiry_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_name` varchar(50) DEFAULT NULL,
  `event_description` text,
  `event_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `follow_up`
--

DROP TABLE IF EXISTS `follow_up`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `follow_up` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `enquiry_id` int DEFAULT NULL,
  `called_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `called_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `called_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `price_offered` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `followup_date` date DEFAULT NULL,
  `next_followup_date` date DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `follow_up_products` int DEFAULT NULL,
  `next_followup_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `location` json DEFAULT NULL,
  `dial_start_time` datetime DEFAULT NULL,
  `dial_end_time` datetime DEFAULT NULL,
  `call_type` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `meeting_conducted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `follow_up`
--

LOCK TABLES `follow_up` WRITE;
/*!40000 ALTER TABLE `follow_up` DISABLE KEYS */;
INSERT INTO `follow_up` VALUES (54,28,1,'','3','Follow-up Required','123','123','2024-12-07','2024-12-07',NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(55,28,1,'','3','Follow-up Required',NULL,NULL,'2024-12-07','2024-12-07',NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(56,28,1,'','3','Follow-up Required',NULL,NULL,'2024-12-07',NULL,NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(57,28,1,'','3','Follow-up Required',NULL,NULL,'2024-12-07',NULL,NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(58,28,1,'','3','Follow-up Required',NULL,NULL,'2024-12-07','2024-12-08',NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(59,28,6,'','3','Follow-up Required',NULL,NULL,'2024-12-09','2024-12-09',NULL,NULL,'Call','null',NULL,NULL,'Inbound Call',NULL),(60,28,6,'','3','Follow-up Required',NULL,NULL,'2024-12-09',NULL,NULL,NULL,'Call','null',NULL,NULL,'Outbound Call',NULL),(61,28,6,'','3','Follow-up Required',NULL,NULL,'2024-12-09',NULL,NULL,NULL,'Call','null',NULL,NULL,'Outbound Call',NULL),(62,28,6,'','3','Follow-up Required',NULL,NULL,'2024-12-09',NULL,NULL,NULL,'Call','null',NULL,NULL,'Outbound Call',NULL),(63,28,6,'','3','Follow-up Required',NULL,NULL,'2024-12-09',NULL,NULL,NULL,'Call','null','2024-12-09 08:51:05','2024-12-09 08:51:10','Outbound Call',NULL);
/*!40000 ALTER TABLE `follow_up` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `follow_up_products`
--

DROP TABLE IF EXISTS `follow_up_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `follow_up_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int DEFAULT NULL,
  `follow_up_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `follow_up_fk_id` (`follow_up_id`),
  CONSTRAINT `follow_up_fk_id` FOREIGN KEY (`follow_up_id`) REFERENCES `follow_up` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `follow_up_products`
--

LOCK TABLES `follow_up_products` WRITE;
/*!40000 ALTER TABLE `follow_up_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `follow_up_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marketers`
--

DROP TABLE IF EXISTS `marketers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `marketers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `contact` varchar(50) DEFAULT NULL,
  `business_name` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marketers`
--

LOCK TABLES `marketers` WRITE;
/*!40000 ALTER TABLE `marketers` DISABLE KEYS */;
/*!40000 ALTER TABLE `marketers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `office`
--

DROP TABLE IF EXISTS `office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `office` (
  `id` int NOT NULL AUTO_INCREMENT,
  `organization_id` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sender_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `port` int DEFAULT NULL,
  `quot_inactive_days` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `organization_id` (`organization_id`),
  CONSTRAINT `office_ibfk_1` FOREIGN KEY (`organization_id`) REFERENCES `organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `office`
--

LOCK TABLES `office` WRITE;
/*!40000 ALTER TABLE `office` DISABLE KEYS */;
INSERT INTO `office` VALUES (18,21,'Lahore','xyz@gamil.com','123','123',123,30),(20,21,'Karachi','dave@gmail.com','456','admin',456,NULL),(21,21,'Islamabad','xyz@gmail.com','123','123',123,NULL),(22,21,'Lahore','123','123','admin',123,30),(23,21,'A','A','A','admin',1,123),(24,21,'b','v','v','admin',1,1);
/*!40000 ALTER TABLE `office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `organization`
--

DROP TABLE IF EXISTS `organization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `organization` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `currency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PKR',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `organization`
--

LOCK TABLES `organization` WRITE;
/*!40000 ALTER TABLE `organization` DISABLE KEYS */;
INSERT INTO `organization` VALUES (21,'Enfo','PKR');
/*!40000 ALTER TABLE `organization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role_id` int DEFAULT NULL,
  `user_tab` tinyint DEFAULT '0',
  `user_add` tinyint(1) DEFAULT NULL,
  `user_view` tinyint(1) DEFAULT NULL,
  `user_delete` tinyint(1) DEFAULT NULL,
  `user_edit` tinyint(1) DEFAULT NULL,
  `role_tab` tinyint(1) DEFAULT NULL,
  `role_add` tinyint(1) DEFAULT NULL,
  `role_delete` tinyint(1) DEFAULT NULL,
  `organization_tab` tinyint(1) DEFAULT NULL,
  `organization_add` tinyint(1) DEFAULT NULL,
  `organization_delete` tinyint(1) DEFAULT NULL,
  `office_tab` tinyint(1) DEFAULT NULL,
  `office_add` tinyint(1) DEFAULT NULL,
  `office_delete` tinyint(1) DEFAULT NULL,
  `cat_level_one_tab` tinyint(1) DEFAULT NULL,
  `cat_level_one_add` tinyint(1) DEFAULT NULL,
  `cat_level_one_delete` tinyint(1) DEFAULT NULL,
  `cat_level_two_tab` tinyint(1) DEFAULT NULL,
  `cat_level_two_add` tinyint(1) DEFAULT NULL,
  `cat_level_two_delete` tinyint(1) DEFAULT NULL,
  `cat_level_three_tab` tinyint(1) DEFAULT NULL,
  `cat_level_three_add` tinyint(1) DEFAULT NULL,
  `cat_level_three_delete` tinyint(1) DEFAULT NULL,
  `cat_level_four_tab` tinyint(1) DEFAULT NULL,
  `cat_level_four_add` tinyint(1) DEFAULT NULL,
  `cat_level_four_delete` tinyint(1) DEFAULT NULL,
  `enquiry_field_tab` tinyint(1) DEFAULT NULL,
  `enquiries_tab` tinyint(1) DEFAULT NULL,
  `enquiries_add` tinyint(1) DEFAULT NULL,
  `enquiries_delete` tinyint(1) DEFAULT NULL,
  `enquiries_edit` tinyint(1) DEFAULT NULL,
  `enquiries_view` tinyint(1) DEFAULT NULL,
  `enquiries_assign` tinyint(1) DEFAULT NULL,
  `follow_up_tab` tinyint(1) DEFAULT NULL,
  `follow_up_add` tinyint(1) DEFAULT NULL,
  `follow_up_view` tinyint(1) DEFAULT NULL,
  `customer_tab` tinyint(1) DEFAULT '0',
  `followup_report` tinyint NOT NULL DEFAULT '0',
  `enquiry_report` tinyint NOT NULL DEFAULT '0',
  `products_tab` tinyint NOT NULL DEFAULT '0',
  `products_add` tinyint NOT NULL DEFAULT '0',
  `products_edit` tinyint NOT NULL DEFAULT '0',
  `products_delete` tinyint NOT NULL DEFAULT '0',
  `cat_level_four_update` tinyint NOT NULL DEFAULT '0',
  `cat_level_three_update` tinyint NOT NULL DEFAULT '0',
  `cat_level_one_update` tinyint NOT NULL DEFAULT '0',
  `cat_level_two_update` tinyint NOT NULL DEFAULT '0',
  `organization_update` tinyint NOT NULL DEFAULT '0',
  `permissionscol` tinyint NOT NULL DEFAULT '0',
  `location_report` tinyint(1) DEFAULT NULL,
  `role_config_kpi` tinyint(1) DEFAULT NULL,
  `products_inventory` tinyint(1) DEFAULT NULL,
  `products_recevings` tinyint(1) DEFAULT NULL,
  `products_quotations` tinyint(1) DEFAULT NULL,
  `products_quotations_approval` tinyint(1) DEFAULT NULL,
  `products_sales_order` tinyint(1) DEFAULT NULL,
  `performace_kpi_report` tinyint(1) DEFAULT NULL,
  `performace_kpi` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (51,10,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,NULL,1,1,1,1,1,1,1,1),(52,12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,NULL,1,1,1,1,1,1,NULL,NULL),(53,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(57,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(58,17,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(59,18,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(60,19,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(61,20,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(62,22,1,1,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(63,23,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_recevings`
--

DROP TABLE IF EXISTS `product_recevings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_recevings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `quantity` int DEFAULT NULL,
  `date_recevings` text,
  `product_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_recevings`
--

LOCK TABLES `product_recevings` WRITE;
/*!40000 ALTER TABLE `product_recevings` DISABLE KEYS */;
INSERT INTO `product_recevings` VALUES (1,213,NULL,16),(2,123,'2024-11-25T14:27:24.074Z',16),(3,11,'2024-11-25T14:37:03.443Z',18),(4,35,'2025-11-25T14:37:11.136Z',18),(5,10,'2024-11-27T13:11:25.654Z',22),(6,12,'2024-12-04T09:27:03.101Z',27),(7,5,'2024-12-04T09:34:53.493Z',23);
/*!40000 ALTER TABLE `product_recevings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_service_charges`
--

DROP TABLE IF EXISTS `product_service_charges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_service_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `range_start` int DEFAULT NULL,
  `range_end` int DEFAULT NULL,
  `unit_price` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `additional_amount` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_service_charges`
--

LOCK TABLES `product_service_charges` WRITE;
/*!40000 ALTER TABLE `product_service_charges` DISABLE KEYS */;
INSERT INTO `product_service_charges` VALUES (1,1,50,0,25,'Kw',0),(2,51,100,400,25,'Kw',0),(3,101,1000,300,25,'Kw',20000);
/*!40000 ALTER TABLE `product_service_charges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `type_of_product` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `price` int NOT NULL DEFAULT '0',
  `quantity` int DEFAULT NULL,
  `supplier` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (22,'Lvi1','N/A','Product','2024-11-27 09:46:52',20000,110,'Lvi1'),(23,'Lvi3','N/A','Product','2024-11-27 09:47:09',45000,101,'Lvi3'),(24,'Lvi9','N/A','Product','2024-11-27 09:47:28',90000,50,'Lvi9'),(25,'Energy Audit','N/A','Service','2024-11-27 09:47:56',15000,0,'N/A'),(28,'AA','A','product','2024-12-07 13:08:40',1,0,'A'),(29,'A','A','service','2024-12-07 13:08:50',2,0,NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotations`
--

DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_id` int DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `dated` varchar(255) DEFAULT NULL,
  `to_person` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `subject_quot` varchar(255) DEFAULT NULL,
  `analysis_of` varchar(255) DEFAULT NULL,
  `sincerely_from` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `approval` enum('Pending','Approved') DEFAULT NULL,
  `is_sales_order` tinyint(1) DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotations`
--

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
INSERT INTO `quotations` VALUES (1,6,'a','a','2024-12-09T08:54:19.798Z','a','a','a',NULL,'admin','a',NULL,NULL,NULL,28);
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary view structure for view `quotations_expiry`
--

DROP TABLE IF EXISTS `quotations_expiry`;
/*!50001 DROP VIEW IF EXISTS `quotations_expiry`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `quotations_expiry` AS SELECT 
 1 AS `id`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `quotations_items`
--

DROP TABLE IF EXISTS `quotations_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotations_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `quotations_id` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `service_category` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `service_units` int DEFAULT NULL,
  `service_units_price` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotations_items`
--

LOCK TABLES `quotations_items` WRITE;
/*!40000 ALTER TABLE `quotations_items` DISABLE KEYS */;
INSERT INTO `quotations_items` VALUES (2,1,23,NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `quotations_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `self_inquiries` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (10,'Admin',0),(12,'Admission Manager',0),(18,'Inquiry Officer',1),(19,'Admission Assistant',1),(20,'Recruitment Agent',1),(22,'Test',1),(23,'Sales Officer',1),(25,'Test',0);
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_order`
--

DROP TABLE IF EXISTS `sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_id` int DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `dated` varchar(255) DEFAULT NULL,
  `to_person` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `subject_quot` varchar(255) DEFAULT NULL,
  `analysis_of` varchar(255) DEFAULT NULL,
  `sincerely_from` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_order`
--

LOCK TABLES `sales_order` WRITE;
/*!40000 ALTER TABLE `sales_order` DISABLE KEYS */;
INSERT INTO `sales_order` VALUES (1,30,'waseem@enfo.ai','+92-310-162 1444 ','2024-11-26T19:00:00.000Z','Dimotec Engineering Company','Lahore','Quotation for Energy Efficiency analysis',' Dimotec Engineering Company','Waseem Arshad','Industrial Energy Consultant'),(2,29,'xyz@gmail.com','99999999','2024-11-26T19:00:00.000Z','ABC','Lahore','abc','aa','xyz','Energy Consultant');
/*!40000 ALTER TABLE `sales_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_order_items`
--

DROP TABLE IF EXISTS `sales_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `quotations_id` int DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `service_category` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `price` int DEFAULT NULL,
  `service_units` int DEFAULT NULL,
  `service_units_price` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_order_items`
--

LOCK TABLES `sales_order_items` WRITE;
/*!40000 ALTER TABLE `sales_order_items` DISABLE KEYS */;
INSERT INTO `sales_order_items` VALUES (1,1,23,NULL,96,NULL,NULL,NULL),(2,1,25,NULL,NULL,NULL,10,NULL),(3,2,24,NULL,100,NULL,NULL,NULL),(4,2,25,NULL,NULL,NULL,110,NULL);
/*!40000 ALTER TABLE `sales_order_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_kpis_manual_relation`
--

DROP TABLE IF EXISTS `user_kpis_manual_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_kpis_manual_relation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `kpi_id` int DEFAULT NULL,
  `weight` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_kpis_manual_relation`
--

LOCK TABLES `user_kpis_manual_relation` WRITE;
/*!40000 ALTER TABLE `user_kpis_manual_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_kpis_manual_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_location`
--

DROP TABLE IF EXISTS `user_location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_location` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `location` json DEFAULT NULL,
  `at_time` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_location`
--

LOCK TABLES `user_location` WRITE;
/*!40000 ALTER TABLE `user_location` DISABLE KEYS */;
INSERT INTO `user_location` VALUES (1,28,NULL,'2024-12-05T12:56:51.803Z'),(2,28,NULL,'2024-12-05T13:11:57.786Z'),(3,28,NULL,'2024-12-05T13:27:05.815Z'),(4,28,NULL,'2024-12-05T13:42:14.828Z'),(5,28,NULL,'2024-12-05T13:57:23.834Z'),(6,28,NULL,'2024-12-05T14:12:32.837Z'),(7,28,'{\"latitude\": 31.4813599, \"longitude\": 74.3264755}','2024-12-06T10:07:48.489Z'),(8,28,'{\"latitude\": 31.4813599, \"longitude\": 74.3264755}','2024-12-06T10:27:52.940Z'),(9,28,'{\"latitude\": 31.4813599, \"longitude\": 74.3264755}','2024-12-06T10:43:08.016Z'),(10,28,'{\"latitude\": 31.4813599, \"longitude\": 74.3264755}','2024-12-06T10:58:19.760Z'),(11,28,'{\"latitude\": 31.4792014, \"longitude\": 74.3259228}','2024-12-07T10:06:10.107Z'),(12,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T10:21:19.504Z'),(13,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T10:36:29.511Z'),(14,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T12:39:55.914Z'),(15,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T12:54:56.010Z'),(16,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T13:09:56.914Z'),(17,28,'{\"latitude\": 31.4792056, \"longitude\": 74.3259236}','2024-12-07T13:25:02.221Z'),(18,28,'{\"latitude\": 31.4825593, \"longitude\": 74.3235425}','2024-12-09T06:20:11.636Z'),(19,28,'{\"latitude\": 31.4825593, \"longitude\": 74.3235425}','2024-12-09T06:47:43.774Z'),(20,28,'{\"latitude\": 31.4825593, \"longitude\": 74.3235425}','2024-12-09T07:03:16.095Z'),(21,28,'{\"latitude\": 31.4825593, \"longitude\": 74.3235425}','2024-12-09T07:18:25.679Z'),(22,28,'{\"latitude\": 31.4791987, \"longitude\": 74.3259192}','2024-12-09T07:38:54.213Z'),(23,28,NULL,'2024-12-09T07:53:54.772Z'),(24,28,NULL,'2024-12-09T08:09:03.968Z'),(25,28,'{\"latitude\": 31.4791987, \"longitude\": 74.3259192}','2024-12-09T08:24:10.894Z'),(26,28,NULL,'2024-12-09T08:39:14.272Z'),(27,28,'{\"latitude\": 31.4791987, \"longitude\": 74.3259192}','2024-12-09T08:54:14.351Z');
/*!40000 ALTER TABLE `user_location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `full_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` int NOT NULL,
  `cnic` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mobile_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `landline` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `office_id` int DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (28,'admin','admin','admin@gmail.com','$2y$10$fRo40oXhp/NfLGwLedhfUO/DPVaIAHYCX0dOsFcn8SsXD50Ci4ycu',10,'1','1','1',18,1),(29,'John','John','john@gmail.com','$2y$10$NtBSse54rfdAJNjlaXaPpuX2KuNK6vDhS12K9rg3C90zY/hhL8Yh.',18,'92 321 8410724 ','92 321 8410724','92 321 8410724',18,1),(30,'lsbc','lsbc','info@lsbc.uk','$2y$10$UKhYvbGHEZscauVQC7QzAug3R88lE.NvM99vZ3jGUpbVMG3qiYrOC',10,'1','07939321830','02085548973',18,1),(31,'zubair','zubair','zubair@gmail.com','$2y$10$ClOGAkWQigSZa5uIrJd6OukczGnkZuZj8BpraRc1UPJxhpWHGY2vW',10,NULL,NULL,NULL,18,1),(33,'Jacob Grayson','Jacob','jacob@gmail.com','$2y$10$Rmu73vwvRTJkcn4insJZwutgqUkcQOWEZMd6NAIpCgVe4qSBIDMi.',19,'6587410054','079568989441','020854712638',18,1),(35,'arshad','waseem','Waseem@enfo.ai','$2y$10$S7BgswjeofVToMqN0qb0ZekKx.5XY3Q2ncZO76jXSTMCm8aMTDNz.',10,'1','03004450504',NULL,18,1),(36,'Muhammad Javed','j4javed','j4javed@hotmail.com','$2y$10$f88RJ0c/THhKIxeGJj.OSOEPumx/3nv.fVbILqYSjmrBlzW3pvR5q',20,'12345678',NULL,NULL,18,1),(37,'test123','Test 123','test123@gamil.com','$2y$10$D3HyR1nxrAKWM.JQxAGQf.NOKgFHoUaO92vEpczQycK60PwVXqNLW',20,'123','123','123',18,1),(38,'AA','AA','info@lsbc.ukasd','$2y$10$UH5umyBT.CYVJynIMiZFH.GeB9/7.q096AKz9U7QKo7p87CVBYPrS',10,'122','123','123',18,1),(39,'Asim','asim','asim@gmail.com','$2y$10$OKrHwo7WiTRquC6Hzw0qTOCNKl8wteYq9jArn6eQ5BvYJK8bfSPm2',18,'123','123','121',18,1),(40,'xyz','XYZ','zubair@gmail.com','$2y$10$HStTLiOyvNeCls7YZWAmCu9BS4AEFt1KcDlSq64mV4tAS8C8ns/pC',23,'123','123','123',18,1),(43,'zubair','zubair123','zubair@gamil.com','$2y$10$1kxnLDxYDYhQ8JSuEf6xjuX1xxcAuC5JUbWub0mM6MNPsZNygIa6K',10,NULL,NULL,NULL,18,1);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Final view structure for view `quotations_expiry`
--

/*!50001 DROP VIEW IF EXISTS `quotations_expiry`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `quotations_expiry` AS select distinct `q`.`id` AS `id` from ((`quotations` `q` join `enquiries` `en` on((`q`.`enquiry_id` = `en`.`id`))) join `office` `o` on((`o`.`id` = `en`.`office_id`))) where ((now() + interval `o`.`quot_inactive_days` day) <= cast(`q`.`dated` as date)) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-12-09 13:55:35
