<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (!is_array($data) || empty($data)) {
            throw new Exception("No data provided for insertion.");
        }

        // Check unique_number requirement
        $unique_number = $conn->query("SELECT unique_number FROM organization LIMIT 1")->fetch(PDO::FETCH_ASSOC)['unique_number'];

        if ($unique_number == 1) {
            foreach ($data as $row) {
                if (!isset($row['mobile_no_one'])) {
                    throw new Exception("Missing Mobile No. in some rows.");
                }

                $stmt = $conn->prepare("SELECT mobile_no_one FROM enquiries WHERE mobile_no_one = :mobile_no_one LIMIT 1");
                $stmt->bindParam(':mobile_no_one', $row['mobile_no_one'], PDO::PARAM_STR);
                $stmt->execute();

                if ($stmt->rowCount() > 0) {
                    throw new Exception("Duplicate Mobile No. found in : " . $row['mobile_no_one']);
                }
            }
        }

        // Get default enquiry status
        $status = $conn->query("SELECT title FROM config_lead_stages WHERE set_initial = 1 LIMIT 1")->fetch(PDO::FETCH_ASSOC)['title'] ?? '';

        // Prepare bulk insert query
        $fields = [
            'enquiry_by',
            'enquiry_entered_by',
            'income_range',
            'enquiry_date',
            'username',
            'cnic',
            'date_of_birth',
            'email',
            'father_name',
            'gender',
            'landline',
            'project',
            'product',
            'developer',
            'price_offered',
            'property_address',
            'source_of_information',
            'enquiry_status',
            'remarks',
            'office_id',
            'cat_one_id',
            'cat_two_id',
            'cat_three_id',
            'cat_four_id',
            'matured',
            'image',
            'city',
            'present_address',
            'permanent_address',
            'mobile_no_one',
            'mobile_no_two'
        ];
        $customFields = [
            'field_one',
            'field_two',
            'field_three',
            'field_four',
            'field_five',
            'field_six',
            'field_seven',
            'field_eight',
            'field_nine',
            'field_ten',
            'field_eleven',
            'field_twelve',
            'field_thirteen',
            'field_fourteen',
            'field_fifteen',
            'field_sixteen',
            'field_seventeen',
            'field_eighteen',
            'field_nineteen',
            'field_twenty'
        ];
        $allFields = array_merge($fields, $customFields);

        $placeholders = implode(', ', array_map(fn($field) => ":$field", $allFields));
        $columns = implode(', ', $allFields);

        $stmt = $conn->prepare("
            INSERT INTO enquiries ($columns, enquiry_status_steps)
            VALUES ($placeholders, '$status')
        ");

        // Start transaction for bulk insert
        $conn->beginTransaction();

        foreach ($data as $row) {
            foreach ($allFields as $field) {
                $stmt->bindValue(":$field", $row[$field] ?? null);
            }
            $stmt->execute();
        }

        // Commit transaction
        $conn->commit();

        $response = [
            "success" => true,
            "message" => "Bulk enquiries inserted successfully."
        ];
    } catch (Exception $e) {
        if ($conn->inTransaction()) {
            $conn->rollBack();
        }

        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}
