<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $sql = "SELECT * FROM config_kpis WHERE on_report = 1";
        // $sql = "SELECT * FROM users WHERE id IN (SELECT user_id from follow_up)";
        $params = [];

        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $kpis = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($kpis) > 0) {
            $response = [
                 "success" => true,
                "data" => $kpis
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
