<?php
include '../../config.php';


if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $user_id = $_GET['id'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];
        $role_id = $_GET['role_id'];

        // Prepare SQL query
        $sql = "SELECT ck.*,ckr.weight, ckr.id as ckr_id FROM config_kpis ck 
                INNER JOIN config_kpis_role ckr ON ck.id = ckr.kpi_id 
                WHERE ckr.role_id = :role_id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($result as $key => &$value) { // Use reference to modify $result directly
                $data = [
                    "user_id" => $user_id,
                    "start_date" => $start_date,
                    "end_date" => $end_date,
                    "kpi_role_id" => $value['ckr_id'],
                    "kpi_id" => $value['id'],
                ];


                // Append function output to each result item
                if ($value['id'] == 2) {
                    $value['weight_gained'] = getLeadConversionRate($data, $conn);
                } else if ($value['id'] == 3) {
                    $value['weight_gained'] = getAvgSalesCycle($data, $conn);
                } else if ($value['id'] == 4) {
                    $value['weight_gained'] = getEfficiencyAndPipeline($data, $conn);
                } else if ($value['id'] == 5) {
                    $value['weight_gained'] = getForeCastAccuracy($data, $conn);
                } else if ($value['id'] == 6) {
                    $value['weight_gained'] = getMeetings($data, $conn);
                } else if ($value['id'] == 8) {
                    $value['weight_gained'] = getMarketers($data, $conn);
                } else if ($value['id'] == 9) {
                    $value['weight_gained'] = getClientTraining($data, $conn);
                } else if ($value['id'] == 10) {
                    $value['weight_gained'] = getCallVolActTotalCalls($data, $conn);
                } else if ($value['id'] == 11) {
                    $value['weight_gained'] = getCallVolActTimePerCall($data, $conn);
                } else if ($value['id'] == 12) {
                    $value['weight_gained'] = getQualifiedLeadsGenerated($data, $conn);
                } else if ($value['id'] == 13) {
                    $value['weight_gained'] = getLeadToAppointRatio($data, $conn);
                } else if ($value['id'] == 14) {
                    $value['weight_gained'] = getEfficiencyMatrix($data, $conn);
                } else if ($value['id'] == 15) {
                    $value['weight_gained'] = getAverageDealSize($data, $conn);
                } else {
                    $value['weight_gained'] = getCrmUtilRate($data, $conn);
                }
            }

            $response = [
                "success" => true,
                "data" => $result
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}



function getLeadConversionRate($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT 
                   (SUM(CASE WHEN enquiry_status_steps IN (SELECT title FROM config_lead_stages WHERE matured_status = 1) THEN 1 ELSE 0 END) /
                    count(*)) * 100 as total
                FROM enquiries eq
                INNER JOIN assign_enquiries aq ON eq.id = aq.enquiry_id
                WHERE DATE(eq.created_at) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND aq.user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";


    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getAvgSalesCycle($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT 
                   AVG(DATEDIFF(enquiry_matured_date, created_at)) as date_diff
                FROM enquiries eq
                INNER JOIN assign_enquiries aq ON eq.id = aq.enquiry_id
                WHERE DATE(eq.created_at) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND aq.user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getEfficiencyAndPipeline($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "
    SELECT weight
    FROM config_kpis_role_table
    WHERE (
        SELECT 
            CASE 
                WHEN COUNT(
                        CASE 
                            WHEN fu.followup_date = fu.next_followup_date 
                            THEN 1 
                            ELSE NULL 
                        END
                    ) > 0 AND 
                    COUNT(
                        *
                    ) > 0 
                THEN 
                    (COUNT(
                        CASE 
                            WHEN fu.followup_date = fu.next_followup_date 
                         THEN 1 
                            ELSE NULL 
                        END
                    ) - 1) / 
                    NULLIF(
                        COUNT(
                           *
                        ) - 1, 0
                    ) * 100 
                ELSE 0
            END AS total
        FROM follow_up fu
        INNER JOIN assign_enquiries aq 
            ON aq.enquiry_id = fu.enquiry_id 
        WHERE aq.user_id = $user_id
        AND fu.followup_date BETWEEN DATE('$start_date') AND DATE('$end_date')
    ) BETWEEN start_range AND end_range
    AND kpi_role_id = $kpi_role_id;
";


    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}


function getForeCastAccuracy($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
               SELECT 
                   COUNT(is_sales_order) / COUNT(*) * 100 as total
                FROM quotations WHERE DATE(dated) BETWEEN DATE('$start_date') AND DATE('$end_date') AND user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getMeetings($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT count(*) as total FROM follow_up 
                WHERE follow_up_type = 'Meeting' AND follow_up_status = 'Attended'
                AND DATE(followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getMarketers($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT count(*) FROM marketers 
                WHERE DATE(created_at) 
                BETWEEN DATE('$start_date') AND DATE('$end_date')
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getClientTraining($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT count(*) FROM events 
                WHERE DATE(event_date) 
                BETWEEN DATE('$start_date') AND DATE('$end_date')
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getCallVolActTotalCalls($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT COUNT(*) AS total FROM follow_up 
                WHERE follow_up_type = 'Call' AND follow_up_status = 'Attended' 
                AND DATE(followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getCallVolActTimePerCall($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
               SELECT (SUM(TIMESTAMPDIFF(SECOND, dial_start_time, dial_end_time)) / count(*)) AS diff_in_minutes
                FROM follow_up WHERE follow_up_type = 'Call' 
                AND dial_start_time IS NOT NULL 
                AND dial_end_time IS NOT NULL 
                AND DATE(followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getQualifiedLeadsGenerated($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
               SELECT count(DISTINCT e.id) as total FROM enquiries e
                INNER JOIN assign_enquiries ae ON ae.enquiry_id = e.id
                WHERE enquiry_status_steps = 'Qualification' 
                AND DATE(created_at) 
                    BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND ae.user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getLeadToAppointRatio($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT 
                    (total_meetings.total_meeting_sum / total_enquiries.total_enq) * 100 AS avg_enquiries_per_meeting
                FROM (
                    SELECT 
                        SUM(total_meeting) AS total_meeting_sum
                    FROM (
                        SELECT 
                            COUNT(DISTINCT enquiry_id) AS total_meeting
                        FROM follow_up
                        WHERE follow_up_type = 'Meeting' AND follow_up_status = 'Attended'
                        AND DATE(followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                        AND user_id = $user_id
                        GROUP BY enquiry_id
                    ) AS meeting_subquery
                ) AS total_meetings,
                (
                    SELECT 
                        COUNT(*) AS total_enq
                    FROM enquiries
                    INNER JOIN assign_enquiries ON enquiries.id = assign_enquiries.enquiry_id
                    WHERE DATE(enquiries.created_at) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                    AND assign_enquiries.user_id = $user_id
                ) AS total_enquiries
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id;
            ";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getEfficiencyMatrix($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT 
                    (
                        (
                            SUM(CASE WHEN follow_up_status = 'Not Attended' THEN 1 ELSE 0 END)
                        ) / COUNT(*)
                    ) * 100 AS total
                FROM follow_up
                WHERE follow_up_type = 'Call'
                AND DATE(followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id;
            ";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getAverageDealSize($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_role_id = $data['kpi_role_id'];

    $sql = "SELECT weight 
            FROM config_kpis_role_table 
            WHERE (
                SELECT  
                (SUM(CASE
                    WHEN qi.quantity IS NOT NULL THEN qi.quantity * p.price ELSE p.price
                END) / COUNT(DISTINCT q.id)) AS total 
                FROM quotations_items qi 
                INNER JOIN quotations q ON qi.quotations_id = q.id
                INNER JOIN products p ON qi.product_id = p.id
                LEFT JOIN product_service_charges psc ON psc.id = qi.service_category
                WHERE DATE(q.dated) BETWEEN DATE('$start_date') AND DATE('$end_date') 
                AND q.user_id = $user_id
            ) BETWEEN start_range AND end_range 
            AND kpi_role_id = $kpi_role_id;
            ";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}

function getCrmUtilRate($data, $conn)
{
    $user_id = $data['user_id'];
    $start_date = $data['start_date'];
    $end_date = $data['end_date'];
    $kpi_id = $data['kpi_id'];

    $sql = "SELECT weight FROM user_kpis_manual_relation WHERE user_id = $user_id AND kpi_id = $kpi_id ;";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res['weight'] ?? 0;
}
