<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['kpi_id']) && isset($data['role_id']) && isset($data['weight'])) {

            $role_id = $data['role_id'];
            $kpi_id = $data['kpi_id'];
            $weight = $data['weight'];
            $table_data = $data['range'] ?? [];

            $weightCheck = "SELECT ((sum(weight) + $weight) - COALESCE((SELECT SUM(weight) 
                                    FROM config_kpis_role 
                                    WHERE role_id = $role_id AND kpi_id = $kpi_id), 0)) AS total FROM config_kpis_role WHERE role_id = $role_id";

            $weightCheck = $conn->prepare($weightCheck);
            $weightCheck->execute();
            $weightCheck = $weightCheck->fetch(PDO::FETCH_ASSOC) ?? 0;

            if($weightCheck['total'] > 100){
                throw new Exception("Weight cant not exceed 100%");
            }


            // Check if the KPI and role already exist
            $check_sql = "SELECT id FROM config_kpis_role WHERE role_id = :role_id AND kpi_id = :kpi_id";
            $stmt = $conn->prepare($check_sql);
            $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);
            $stmt->bindParam(':kpi_id', $kpi_id, PDO::PARAM_INT);
            $stmt->execute();
            $existing_kpi_role = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($existing_kpi_role) {
                $sql = "UPDATE config_kpis_role SET weight = :weight WHERE id = :id";
                $stmt = $conn->prepare($sql);
                $stmt->bindParam(':id', $existing_kpi_role['id'], PDO::PARAM_INT);
                $kpi_role_id = $existing_kpi_role['id'];
            } else {
                $sql = "INSERT INTO config_kpis_role (role_id, kpi_id, weight) VALUES (:role_id, :kpi_id, :weight)";
                $stmt = $conn->prepare($sql);
                $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);
                $stmt->bindParam(':kpi_id', $kpi_id, PDO::PARAM_INT);
                $kpi_role_id = null; // Set to null for clarity
            }
            $stmt->bindParam(':weight', $weight);
            $stmt->execute();

            $kpi_role_id = $conn->lastInsertId();


            if (!$kpi_role_id) {
                $check_sql_table = "DELETE FROM config_kpis_role_table WHERE role_id = $role_id AND kpi_role_id = $existing_kpi_role[id]";
                $stmt_table = $conn->prepare($check_sql_table);
                $stmt_table->execute();
                $existing_table_row = $stmt_table->fetch(PDO::FETCH_ASSOC);
            }
            // Handle the range data
            foreach ($table_data as $value) {
                $start_range = $value['start_range'];
                $end_range = $value['end_range'];
                $w = $value['weight'];

                $kpi_def_id = $kpi_role_id ? $kpi_role_id : $existing_kpi_role['id'];

                $sql_table = "INSERT INTO config_kpis_role_table (role_id, kpi_role_id, weight, start_range, end_range) VALUES (:role_id, :kpi_role_id, :weight, :start_range, :end_range)";
                $stmt_table = $conn->prepare($sql_table);
                $stmt_table->bindParam(':role_id', $role_id, PDO::PARAM_INT);
                $stmt_table->bindParam(':kpi_role_id', $kpi_def_id, PDO::PARAM_INT);
                $stmt_table->bindParam(':weight', $w);
                $stmt_table->bindParam(':start_range', $start_range, PDO::PARAM_STR);
                $stmt_table->bindParam(':end_range', $end_range, PDO::PARAM_STR);

                if (!$stmt_table->execute()) {
                    throw new Exception("Failed to process range data");
                }
            }

            $response = [
                "success" => true,
                "message" => "Records updated successfully"
            ];
        } else {
            throw new Exception("Missing required fields: kpi_id, role_id, weight, or range");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
