<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {

        if (isset($_GET['id'])) {
            $id = $_GET['id'];

            $stmt = $conn->prepare("DELETE FROM enquiry_images WHERE id = :id");
            $stmt->bindValue(':id', $id);

            // Execute the statement
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "Record deleted successfully"
                ];
            } else {
                throw new Exception("Error executing query.");
            }
        } else {
            throw new Exception("ID is required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
