<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['user_id']) && isset($data['enquiry_id'])) {
            $userId = $data['user_id'];
            $enquiryId = $data['enquiry_id'];
            $status = isset($data['status']) ? $data['status'] : 1; // Default status is true (1)

            // Check if there is an existing entry with the same user_id and enquiry_id
            $checkStmt = $conn->prepare("SELECT id FROM assign_enquiries WHERE user_id = :user_id AND enquiry_id = :enquiry_id AND status = 1");
            $checkStmt->bindValue(':user_id', $userId);
            $checkStmt->bindValue(':enquiry_id', $enquiryId);
            $checkStmt->execute();

            if ($checkStmt->rowCount() > 0) {
                // Update existing entry to set status to false
                $updateStmt = $conn->prepare("UPDATE assign_enquiries SET status = 0 WHERE user_id = :user_id AND enquiry_id = :enquiry_id AND status = 1");
                $updateStmt->bindValue(':user_id', $userId);
                $updateStmt->bindValue(':enquiry_id', $enquiryId);
                $updateStmt->execute();
            }

            // Insert new entry with current date and status true
            $insertStmt = $conn->prepare("INSERT INTO assign_enquiries (user_id, enquiry_id, status, date) VALUES (:user_id, :enquiry_id, :status, NOW())");
            $insertStmt->bindValue(':user_id', $userId);
            $insertStmt->bindValue(':enquiry_id', $enquiryId);
            $insertStmt->bindValue(':status', $status);
            $insertStmt->execute();

            $response = [
                "success" => true,
                "message" => "New record created successfully"
            ];
        } else {
            throw new Exception("User ID and enquiry ID are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
