<?php
include '../../config.php';

function NullifyQuotation($conn)
{
    // Fetch quotations to be nullified
    $fieldStmt = $conn->prepare("
        SELECT DISTINCT q.id
        FROM quotations q
        INNER JOIN enquiries en ON q.enquiry_id = en.id
        INNER JOIN office o ON o.id = en.office_id 
        WHERE DATE_ADD(NOW(), INTERVAL o.quot_inactive_days DAY) <= DATE(q.dated)
    ");
    $fieldStmt->execute();
    $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

    // var_dump($fields);

    // Update each quotation's status
    foreach ($fields as $field) {
        $updateStmt = $conn->prepare("UPDATE quotations SET status = 0 WHERE id = :id");
        $updateStmt->bindParam(':id', $field['id'], PDO::PARAM_INT);
        $updateStmt->execute();
    }

    echo "Done";
}

// Call the function
NullifyQuotation($conn);
?>
