<?php

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;

        if ($id === null) {
            throw new Exception("The 'id' parameter is required");
        }

        // Convert the comma-separated string of IDs into an array
        $idArray = explode(',', $id);

        // Check if there are any IDs to filter by
        if (count($idArray) === 0) {
            throw new Exception("The 'id' parameter must contain at least one value");
        }

        // Dynamically create placeholders for the IN clause
        $placeholders = implode(',', array_fill(0, count($idArray), '?'));

        // Initialize the SQL query with IN condition
        $sql = "SELECT id, name AS cat_three_name FROM category_level_three WHERE category_level_two_id IN ($placeholders)";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind each value to the corresponding placeholder
        foreach ($idArray as $index => $value) {
            $stmt->bindValue($index + 1, $value); // 1-based index for bindValue
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($categories) > 0) {
            $response = [
                "success" => true,
                "data" => $categories
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
