<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {


        if (!isset($_GET['user_id'], $_GET['start_date'], $_GET['end_date'])) {
            throw new Exception("Params Missing");
        }

        $sql = "SELECT 
                    *
                FROM (
                    SELECT 
                        SUM(total_meeting) AS total_meeting_sum
                    FROM (
                        SELECT 
                            COUNT(DISTINCT follow_up_type) AS total_meeting
                        FROM follow_up
                        WHERE follow_up_type = 'Meeting' AND follow_up_status = 'Attended'
                        AND DATE(followup_date) 
                        BETWEEN DATE('$_GET[start_date]') AND DATE('$_GET[end_date]') 
                        AND user_id = $_GET[user_id]
                        GROUP BY enquiry_id
                    ) AS meeting_subquery
                ) AS total_meetings,
                (
                    SELECT 
                        COUNT(*) AS total_enq
                    FROM enquiries
                    INNER JOIN assign_enquiries ON enquiries.id = assign_enquiries.enquiry_id
                    WHERE DATE(created_at) 
                    BETWEEN DATE('$_GET[start_date]') AND DATE('$_GET[end_date]') 
                    AND user_id = $_GET[user_id]
                ) AS total_enquiries;";


        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $kpis = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($kpis) > 0) {
            $response = [
                "success" => true,
                "data" => $kpis
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
