<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $agent = isset($_GET['agent']) ? $_GET['agent'] : [];
        $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
        $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : null;
        $type = isset($_GET['type']) ? $_GET['type'] : [];

        // Initialize the SQL query and parameters
        $sql = "SELECT follow_up.*, users.username, e.username as fullname, e.mobile_no_one as mobile_number 
                FROM follow_up 
                INNER JOIN users ON follow_up.user_id = users.id
                INNER JOIN enquiries e ON e.id = follow_up.enquiry_id";
        $params = [];
        $conditions = [];

        // Handle agent filter
        if (!in_array('All', $agent)) {
            $placeholders = implode(',', array_fill(0, count($agent), '?'));
            $conditions[] = "user_id IN ($placeholders)";
            $params = array_merge($params, $agent);
        }

        // Handle date range filter
        if ($start_date !== null && $end_date !== null) {
            $conditions[] = "DATE(next_followup_date) BETWEEN ? AND ?";
            $params[] = $start_date;
            $params[] = $end_date;
        }

        // Handle type filter
        if (!in_array('All', $type)) {
            $placeholders = implode(',', array_fill(0, count($type), '?'));
            $conditions[] = "follow_up_type IN ($placeholders)";
            $params = array_merge($params, $type);
        }

        // Add conditions to the SQL query
        if (!empty($conditions)) {
            $sql .= " WHERE " . implode(' AND ', $conditions);
        }

        $sql .= " ORDER BY follow_up.enquiry_id, DATE(followup_date) DESC";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind the parameters dynamically
        foreach ($params as $index => $value) {
            $stmt->bindValue($index + 1, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $follow_up_records = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Group follow-ups by enquiry_id
        $enquiries = [];
        foreach ($follow_up_records as $follow_up) {
            $enquiry_id = $follow_up['enquiry_id'];

            // Fetch related products for this follow-up
            $sql_products = "SELECT * FROM follow_up WHERE enquiry_id = $enquiry_id ORDER BY id DESC LIMIT 1";

            $stmt_products = $conn->prepare($sql_products);
            $stmt_products->execute();
            $follow_up_latest = $stmt_products->fetch(PDO::FETCH_ASSOC);

            // Initialize enquiry in result if not already present
            if (!isset($enquiries[$enquiry_id])) {
                $enquiries[$enquiry_id] = [
                    'enquiry_id' => $enquiry_id,
                    'fullname' => $follow_up['fullname'],
                    'mobile_number' => $follow_up['mobile_number'],
                    'latest_follow_up' => $follow_up_latest, // Initially set as the latest follow-up
                    'follow_ups' => []
                ];
            }

            // Add follow-up to the list
            $enquiries[$enquiry_id]['follow_ups'][] = $follow_up;
        }

        // Convert to array and structure the response
        $response = [
            "success" => true,
            "data" => array_values($enquiries) // Reset keys for JSON encoding
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "An error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
