<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
        $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : null;


        $contact_sql = "SELECT mobile_no_one FROM enquiries WHERE id = $id";
        $contact_result = $conn->query($contact_sql);
        $contact_row = $contact_result->fetch(PDO::FETCH_ASSOC);


        // Initialize the SQL query for follow_up
        $sql = "SELECT follow_up.*, users.username FROM follow_up INNER JOIN users ON users.id = follow_up.user_id";
        $params = [];

        // Add conditions based on the provided query parameters
        if ($id !== null) {
            $sql .= " WHERE enquiry_id = :id";
            $params[':id'] = $id;
        }

        // Add date filtering if start_date and end_date are provided
        if ($start_date !== null && $end_date !== null) {
            $sql .= ($id !== null) ? " AND" : " WHERE";
            $sql .= " DATE(next_followup_date) BETWEEN DATE('$start_date') AND DATE('$end_date')";
        }

        $sql .= " ORDER BY DATE(followup_date) DESC";
        $stmt = $conn->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindParam($key, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $follow_up_records = $stmt->fetchAll(PDO::FETCH_ASSOC);


        if (count($follow_up_records) > 0) {
            // For each follow-up record, fetch related products
            foreach ($follow_up_records as &$follow_up) {
                $follow_up_id = $follow_up['id'];

                // SQL query to get products related to this follow-up
                $sql_products = "SELECT p.product_name 
                                 FROM follow_up_products fp
                                 LEFT JOIN products p ON fp.product_id = p.id
                                 WHERE fp.follow_up_id = :follow_up_id";

                // Prepare the statement
                $stmt_products = $conn->prepare($sql_products);
                $stmt_products->bindParam(':follow_up_id', $follow_up_id);

                // Execute the statement
                $stmt_products->execute();

                // Fetch the product names
                $products = $stmt_products->fetchAll(PDO::FETCH_ASSOC);

                // Append the product names to the follow-up record
                $follow_up['products'] = $products;
            }


            $response = [
                "success" => true,
                "data" => $follow_up_records,
                "contact" => $contact_row['mobile_no_one']
            ];
        } else {
            $response = [
                "success" => true,
                "message" => [],
                "contact" => $contact_row['mobile_no_one']
            ];
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
