<?php

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $username = isset($_GET['username']) ? $_GET['username'] : null;

        // Initialize the SQL query
        $sql = "SELECT users.id, 
                users.username, 
                users.full_name, 
                users.email, 
                users.cnic, 
                users.mobile_no, 
                users.landline, 
                users.status,
                office.name AS off_name,  
                office.id AS office_id,  
                roles.role AS role_name,
                roles.id AS role_id
                FROM users
                INNER JOIN office 
                ON users.office_id = office.id 
                LEFT JOIN roles
                ON users.role_id = roles.id WHERE 1 = 1 ";

        // Append conditions to the SQL query if parameters are present
        $conditions = [];
        if ($id) {
            $conditions[] = "users.id = :id";
        }else{
            $conditions[] = "users.status = 1";
        }
        if ($username) {
            $conditions[] = "users.username = :username";
        }

        if (!empty($conditions)) {
            $sql .= "AND " . implode(" AND ", $conditions);
        }


        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters if they exist
        if ($id) {
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        }
        if ($username) {
            $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        }

        // Execute the query
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
