<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query
        $sql = "SELECT count(fu.user_id) as total_count, u.username 
                FROM follow_up fu 
                INNER JOIN users u ON fu.user_id = u.id
                WHERE DATE(fu.followup_date) >= DATE(DATE_SUB(CURDATE(), INTERVAL 7 DAY)) 
                AND DATE(fu.followup_date) <= DATE(CURDATE())
                ";
        
        // Add user_id condition if provided
        if ($user_id) {
            $sql .= " AND u.id = :uid ";
        }
        $sql .= " GROUP BY fu.user_id";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters if user_id is provided
        if ($user_id) {
            $stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
