<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query
        $sql = "SELECT fu.enquiry_id, fu.id, fu.called_status, fu.remarks, fu.followup_date, fu.next_follow_up_type, 
                       u.username AS assigned_to, us.username AS last_follow_up_done_by
                FROM follow_up fu
                INNER JOIN assign_enquiries ae ON ae.enquiry_id = fu.enquiry_id
                INNER JOIN users u ON u.id = ae.user_id
                INNER JOIN users us ON us.id = fu.user_id
                -- WHERE DATE(fu.next_followup_date) = DATE_ADD(CURDATE(), INTERVAL 1 DAY)
                WHERE DATE(fu.next_followup_date) = CURDATE()
                AND ae.status = 1 ";

        $count_sql = "SELECT count(*) as total, fu.next_follow_up_type as type
                FROM follow_up fu
                INNER JOIN assign_enquiries ae ON ae.enquiry_id = fu.enquiry_id
                INNER JOIN users u ON u.id = ae.user_id
                INNER JOIN users us ON us.id = fu.user_id
                WHERE DATE(fu.next_followup_date) = CURDATE()
                AND ae.status = 1 ";

        // Add user_id condition if provided
        if ($user_id) {
            $sql .= "AND ae.user_id = :uid ";
            $count_sql .= "AND ae.user_id = :uid ";
        }

        $count_sql .= "GROUP BY fu.next_follow_up_type";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);
        $count_sql_stmt = $conn->prepare($count_sql);

        // Bind parameters if user_id is provided
        if ($user_id) {
            $stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
            $count_sql_stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
        }

        // Execute the statement
        $stmt->execute();
        $count_sql_stmt->execute();

        // Fetch the records as an associative array
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count_sql_stmt_data = $count_sql_stmt->fetchAll(PDO::FETCH_ASSOC);


        if (count($data) > 0) {
            // Iterate through follow-up records and fetch related products
            foreach ($data as &$follow_up) { // Use reference to modify the array
                $follow_up_id = $follow_up['id'];
                $enquiry_id = $follow_up['enquiry_id'];

                $status_sql = "SELECT enquiry_status_steps FROM enquiries WHERE id = :enquiry_id";
                $status_sql = $conn->prepare($status_sql);
                $status_sql->bindParam(':enquiry_id', $enquiry_id, PDO::PARAM_INT);
                $status_sql->execute();
                $status_enq = $status_sql->fetch(PDO::FETCH_ASSOC); // Fetch a single row as an associative array



                // SQL query to get products related to this follow-up
                $sql_products = "SELECT p.product_name 
                                 FROM follow_up_products fp
                                 LEFT JOIN products p ON fp.product_id = p.id
                                 WHERE fp.follow_up_id = :follow_up_id";

                // Prepare the statement
                $stmt_products = $conn->prepare($sql_products);
                $stmt_products->bindParam(':follow_up_id', $follow_up_id, PDO::PARAM_INT);

                // Execute the statement
                $stmt_products->execute();

                // Fetch the product names
                $products = $stmt_products->fetchAll(PDO::FETCH_ASSOC);

                // Append the product names to the follow-up record
                $follow_up['products'] = $products;
                $follow_up['status_enq'] = $status_enq['enquiry_status_steps'];
            }

            // Prepare the success response
            $response = [
                "success" => true,
                "data" => ["follow_up" => $data, "count" => $count_sql_stmt_data]
            ];
        } else {
            // No follow-up data found
            $response = [
                "success" => false,
                "message" => "No follow-ups found for the given criteria."
            ];
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "An error occurred.",
            "error_details" => $e->getMessage()
        ];
    }

    // Output the response as JSON
    echo json_encode($response);
} else {
    // Handle non-GET requests
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method. Only GET is allowed."
    ]);
}
