<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['product_name']) && isset($data['details']) && isset($data['type_of_product'])) {
            $product_name = $data['product_name'];
            $details = $data['details'];
            $type_of_product = ucfirst($data['type_of_product']);
            $price = $data['price'];
            $quantity = $data['quantity'];
            $supplier = $data['supplier'];

            // Prepare SQL query
            $sql = "INSERT INTO products (product_name, details, type_of_product, price, quantity, supplier) VALUES (:product_name, :details, :type_of_product, :price, :quantity, :supplier)";
            $stmt = $conn->prepare($sql);

            // Bind parameters
            $stmt->bindParam(':product_name', $product_name);
            $stmt->bindParam(':details', $details);
            $stmt->bindParam(':type_of_product', $type_of_product);
            $stmt->bindParam(':price', $price);
            $stmt->bindParam(':quantity', $quantity);
            $stmt->bindParam(':supplier', $supplier);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Missing Fields");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
