<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['id'], $data['name'], $data['currency'], $data['enq_status_steps']) && is_array($data['enq_status_steps'])) {
            $id = $data['id'];
            $name = $data['name'];
            $currency = $data['currency'];
            $unique_number = $data['unique_number'] ? 1 : 0;
            $enq_status_steps = $data['enq_status_steps']; // Array of enq_status_steps
            $date_format = $data['date_format']; // Array of enq_status_steps
            $dialer_feature = $data['dialer_feature']; // Array of enq_status_steps
            $use_location_feature = $data['use_location_feature']; // Array of enq_status_steps

            // Start a transaction
            $conn->beginTransaction();

            // Update organization table
            $stmt = $conn->prepare("UPDATE organization SET name = :name, currency = :currency, unique_number = :unique_number, date_format = :date_format, use_location_feature = :use_location_feature, dialer_feature = :dialer_feature  WHERE id = :id");
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':currency', $currency);
            $stmt->bindParam(':unique_number', $unique_number);
            $stmt->bindParam(':date_format', $date_format);
            $stmt->bindParam(':dialer_feature', $dialer_feature);
            $stmt->bindParam(':use_location_feature', $use_location_feature);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();

            // Delete existing entries for this organization in config_lead_stages
            $deleteStmt = $conn->prepare("DELETE FROM config_lead_stages WHERE org_id = :org_id");
            $deleteStmt->bindParam(':org_id', $id, PDO::PARAM_INT);
            $deleteStmt->execute();

            // Prepare statement for inserting into config_lead_stages
            $statusStmt = $conn->prepare("
                INSERT INTO config_lead_stages (org_id, title, order_no, show_on_screen, matured_status, dropped_status, set_initial) 
                VALUES (:org_id, :title, :order_no, :show_on_screen, :matured_status, :dropped_status, :set_initial)
            ");

            foreach ($enq_status_steps as $status) {
                // Provide default values if keys are missing
                $title = $status['title'] ?? null;
                $order_no = $status['order'] ?? 0;
                $show_on_screen = isset($status['show']) ? (int)$status['show'] : 0;
                $matured_status = isset($status['matured']) ? (int)$status['matured'] : 0;
                $dropped_status = isset($status['dropped']) ? (int)$status['dropped'] : 0;
                $set_initial = isset($status['set_initial']) ? (int)$status['set_initial'] : 0;

                // Bind parameters
                $statusStmt->bindParam(':org_id', $id, PDO::PARAM_INT);
                $statusStmt->bindParam(':title', $title);
                $statusStmt->bindParam(':order_no', $order_no);
                $statusStmt->bindParam(':show_on_screen', $show_on_screen);
                $statusStmt->bindParam(':matured_status', $matured_status);
                $statusStmt->bindParam(':dropped_status', $dropped_status);
                $statusStmt->bindParam(':set_initial', $set_initial);

                // Execute statement for each status
                $statusStmt->execute();
            }

            // Commit the transaction
            $conn->commit();

            $response = [
                "success" => true,
                "message" => "Records updated successfully"
            ];
        } else {
            throw new Exception("Required fields are missing or invalid");
        }
    } catch (PDOException $e) {
        // Rollback the transaction on error
        $conn->rollBack();
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
