<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $name = isset($_GET['name']) ? $_GET['name'] : null;

        // Initialize the SQL query and parameters
        $sql = "SELECT category_level_two.id , category_level_two.name AS cat_name ,category_level_one.name AS cat_one_name
        FROM category_level_two 
        JOIN category_level_one
        ON category_level_one.id = category_level_two.category_level_one_id ";
        $params = [];
        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        foreach ($params as $key => $value) {
            $stmt->bindParam($key, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                // "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
