<?php

include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Initialize the SQL query
        $eq_id = $_GET['eq_id'];
        $sql = "SELECT a.*, users.username AS user_name
                FROM assign_enquiries a
                JOIN users 
                ON a.user_id = users.id
                WHERE a.enquiry_id = :eq_id";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(":eq_id", $eq_id, PDO::PARAM_INT);

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($assignments) > 0) {
            $response = [
                "success" => true,
                "data" => $assignments
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
