<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Decode the JSON input data
        $data = json_decode(file_get_contents("php://input"), true);

        // Check for required fields
        if (isset($data['name'], $data['email'], $data['business_name'], $data['date'], $data['contact'])) {
            
            $name = $data['name'];
            $email = $data['email'];
            $business_name = $data['business_name'];
            $date = $data['date'];
            $contact = $data['contact'];

            // Prepare SQL query using prepared statements
            $stmt = $conn->prepare(
                "INSERT INTO marketers (name, contact, business_name, email, created_at) 
                 VALUES (:name, :contact, :business_name, :email, NOW())"
            );

            // Bind parameters
            $stmt->bindParam(':name', $name, PDO::PARAM_STR);
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->bindParam(':business_name', $business_name, PDO::PARAM_STR);
            $stmt->bindParam(':contact', $contact, PDO::PARAM_STR);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Missing required fields: name, email, business_name, date, or contact.");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database Error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    // Return JSON response
    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method. POST required."
    ]);
}
?>
