<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Get the data from the POST request
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if data is received correctly
        if ($data === null) {
            throw new Exception("Invalid JSON data received");
        }

        // Ensure the 'username' and 'id' fields are provided for identifying the record
        if (!isset($data['id'])) {
            throw new Exception("Username or ID missing");
        }

        $id = intval($data['id']);
        $username = $data['user_name'];
        $full_name = $data['full_name'];
        $email = isset($data['e_mail']) ? $data['e_mail'] : null;
        $role_id = isset($data['role_id']) ? $data['role_id'] : null;
        $cnic = isset($data['cnic']) ? $data['cnic'] : null;
        $mobile_no = isset($data['mobile_no']) ? $data['mobile_no'] : null;
        $landline = isset($data['land_line']) ? $data['land_line'] : null;
        $status = (int) $data['status'] == 2 ? 0 : 1;

        // Initialize the SQL query
        $sql = "UPDATE users SET username = '$username'";
        if ($full_name) $sql .= ", full_name = '$full_name'";
        if ($email) $sql .= ", email = '$email'";
        if ($role_id) $sql .= ", role_id = '$role_id'";
        if ($cnic) $sql .= ", cnic = '$cnic'";
        if ($mobile_no) $sql .= ", mobile_no = '$mobile_no'";
        if ($landline) $sql .= ", landline = '$landline'";

        $sql .= ", status = $status";
        $sql .= " WHERE id = $id";

        if ($conn->query($sql)) {
            $response = [
                "success" => true,
                "message" => "Record updated successfully"
            ];
        } else {
            throw new Exception("No record updated");
        }
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
