<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $data = [];

        // Prepare SQL query for products
        $sql = "SELECT * FROM products";
        $stmt = $conn->prepare($sql);

        // Execute the query
        if ($stmt->execute()) {
            $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Iterate over each product to fetch associated service charges
            foreach ($products as &$product) {
                $sql_service = "SELECT * FROM product_service_charges WHERE product_id = :product_id";
                $service_stmt = $conn->prepare($sql_service);
                $service_stmt->execute(['product_id' => $product['id']]);
                $product['service'] = $service_stmt->fetchAll(PDO::FETCH_ASSOC);
            }

            $data['product'] = $products;

            $response = [
                "success" => true,
                "data" => $data
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
