<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $field_name = isset($_GET['field_name']) ? $_GET['field_name'] : null;

        $sql = "SELECT * FROM enquiry_fields_dropdown WHERE trim(field_name) = '$field_name'";

        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $enquiry_fields = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($enquiry_fields) > 0) {
            $response = [
                "success" => true,
                "data" => $enquiry_fields
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
