<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $query = "SELECT enquiries.*, 
                            office.name AS office_name, 
                            category_level_one.name AS cat_one_name, 
                            category_level_two.name AS cat_two_name, 
                            category_level_three.name AS cat_three_name, 
                            category_level_four.name AS cat_four_name 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                    WHERE 1=1 
                    AND enquiries.id NOT IN (SELECT enquiry_id FROM assign_enquiries) ";

        $params = [];

        $query .= " ORDER BY enquiries.created_at DESC";

        // Prepare and execute the statement
        $stmt = $conn->prepare($query);
        $stmt->execute($params);

        // Fetch all records or a single record
        $results = isset($id) ? [$stmt->fetch(PDO::FETCH_ASSOC)] : $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Fetch field mappings with status 1
        $fieldStmt = $conn->prepare("SELECT field_name, title, order_no FROM enquiry_fields WHERE status = 1 ORDER BY order_no");
        $fieldStmt->execute();
        $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

        // Create a mapping of field names to titles
        $fieldMapping = [];
        foreach ($fields as $field) {
            $fieldMapping[$field['field_name']] = [
                'title' => $field['title'],
                'order_no' => $field['order_no']
            ];
        }

        // Define the required IDs
        $requiredIDs = ['office_name', 'cat_one_name', 'cat_two_name', 'cat_three_name', 'cat_four_name', 'status', 'enquiry_status_steps'];

        $responseData = [];
        foreach ($results as $result) {
            $dataWithTitles = [];
            $processedKeys = [];

            foreach ($result as $key => $value) {
                // Include the required IDs explicitly
                if (isset($fieldMapping[$key]) || in_array($key, $requiredIDs)) {
                    $title = isset($fieldMapping[$key]) ? $fieldMapping[$key]['title'] : ucfirst(str_replace('_', ' ', $key));
                    $order_no = isset($fieldMapping[$key]) ? $fieldMapping[$key]['order_no'] : null;

                    $dataWithTitles[] = [
                        "field_name" => $key,
                        "title" => $title,
                        "value" => $value,
                        "order_no" => $order_no // Add order_no to the response
                    ];
                    $processedKeys[] = $key;
                }
            }

            // Ensure all required IDs are included even if they are null
            foreach ($requiredIDs as $requiredID) {
                if (!in_array($requiredID, $processedKeys)) {
                    $dataWithTitles[] = [
                        "field_name" => $requiredID,
                        "title" => ucfirst(str_replace('_', ' ', $requiredID)),
                        "value" => null,
                        "order_no" => null // Assign null if order_no is not applicable
                    ];
                }
            }

            // Sort $dataWithTitles array by order_no
            usort($dataWithTitles, function ($a, $b) {
                return $a['order_no'] <=> $b['order_no'];
            });







            $responseData[] = [
                "id" => $result['id'],
                "fields" => $dataWithTitles,
            ];
        }

        $response = [
            "success" => true,
            "data" => isset($id) ? $responseData[0] : $responseData
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
