<?php
include '../../../config.php';


function convertUTCtoMySQL($utcDateString)
{
    if (empty($utcDateString)) {
        return null;
    }
    try {
        $date = new DateTime($utcDateString, new DateTimeZone('UTC'));
        $date->setTimezone(new DateTimeZone('UTC')); // Change if needed
        return $date->format('Y-m-d H:i:s');
    } catch (Exception $e) {
        throw new Exception("Invalid date format provided: " . $e->getMessage());
    }
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Decode the JSON input data
        $data = json_decode(file_get_contents("php://input"), true);

        // Check for required fields
        if (isset($data['name'], $data['desc'], $data['date'])) {
            
            $name = $data['name'];
            $desc = $data['desc'];
            $date = convertUTCtoMySQL($data['date']);

            // Prepare SQL query using prepared statements
            $stmt = $conn->prepare(
                "INSERT INTO events (event_name, event_description, event_date) 
                 VALUES (:name, :desc, :date)"
            );

            // Bind parameters
            $stmt->bindParam(':name', $name, PDO::PARAM_STR);
            $stmt->bindParam(':desc', $desc, PDO::PARAM_STR);
            $stmt->bindParam(':date', $date, PDO::PARAM_STR);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Missing required fields");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database Error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    // Return JSON response
    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method. POST required."
    ]);
}
?>
