<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query for the last 7 days
        $sqlLast7Days = " SELECT 
                                IFNULL(called_status, 'N/A') AS called_status,
                                COUNT(called_status) as total
                            FROM 
                                follow_up
                            WHERE 
                                next_followup_date <= DATE_ADD(NOW(), INTERVAL 7 DAY)
                                AND next_followup_date >= NOW()
                                AND next_followup_date is not null
                                AND id IN (SELECT MAX(id) FROM follow_up GROUP BY  enquiry_id) ";

        // Initialize the SQL query for the last 30 days
        $sqlLast30Days = " SELECT 
                                IFNULL(called_status, 'N/A') AS called_status,
                                COUNT(called_status) as total
                            FROM 
                                follow_up
                            WHERE 
                                next_followup_date <= DATE_ADD(NOW(), INTERVAL 30 DAY)
                                AND next_followup_date >= NOW()
                                AND next_followup_date is not null
                                AND id IN (SELECT MAX(id) FROM follow_up GROUP BY  enquiry_id) ";

        // Add user_id condition if provided for both queries
        if ($user_id) {
            $sqlLast7Days .= "AND fu.user_id = :uid ";
            $sqlLast30Days .= "AND fu.user_id = :uid ";
        }

        $sqlLast7Days .= "GROUP BY called_status ";
        $sqlLast30Days .= "GROUP BY called_status ";

        // Prepare the SQL statements
        $stmt7Days = $conn->prepare($sqlLast7Days);
        $stmt30Days = $conn->prepare($sqlLast30Days);

        // Bind parameters if user_id is provided
        if ($user_id) {
            $stmt7Days->bindParam(':uid', $user_id, PDO::PARAM_INT);
            $stmt30Days->bindParam(':uid', $user_id, PDO::PARAM_INT);
        }

        // Execute the statements
        $stmt7Days->execute();
        $stmt30Days->execute();

        // Fetch the records as associative arrays
        $last7DaysData = $stmt7Days->fetchAll(PDO::FETCH_ASSOC);
        $last30DaysData = $stmt30Days->fetchAll(PDO::FETCH_ASSOC);

        // Combine data
        $response = [
            "success" => true,
            "data" => [
                "last_7_days" => $last7DaysData,
                "last_30_days" => $last30DaysData
            ]
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
