<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['user_id']) && isset($data['enquiry_id'])) {
            $userId = $data['user_id'];
            $enquiryId = $data['enquiry_id'];
            $status = 1; // Storing as 'Active'

            // Prepare SQL query
            $sql = "UPDATE assign_enquiries SET status = 0 WHERE enquiry_id = $enquiryId";
            $stmt = $conn->prepare($sql);
            $stmt->execute();

            $sql = "INSERT INTO assign_enquiries (user_id, enquiry_id, status, date) VALUES (:user_id, :enquiry_id, :status, NOW())";
            $stmt = $conn->prepare($sql);

            // Bind parameters
            $stmt->bindParam(':user_id', $userId);
            $stmt->bindParam(':enquiry_id', $enquiryId);
            $stmt->bindParam(':status', $status);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("User ID and enquiry ID are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
