<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $sql = "SELECT * FROM organization LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);


        $enq_stages_data = "SELECT * FROM config_lead_stages";
        $enq_stages_data = $conn->prepare($enq_stages_data);
        $enq_stages_data->execute();
        $enq_stages_data = $enq_stages_data->fetchAll(PDO::FETCH_ASSOC);

        $responseData = [
            "enq_steps" => $enq_stages_data
        ];

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations,
                "responseData" => $responseData
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
