<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $role_id = isset($_GET['id']) ? $_GET['id'] : null;

        if ($role_id === null) {
            throw new Exception("Role ID is required");
        }

        // Prepare the SQL statement
        $sql = "
            SELECT 
                *
            FROM permissions
            WHERE role_id = :role_id
        ";

        // Prepare the statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $permissions = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($permissions) > 0) {
            // Convert 0/1 to false/true
            foreach ($permissions as &$permission) {
                foreach ($permission as $key => $value) {
                    if ($value === '0') {
                        $permission[$key] = false;
                    } elseif ($value === '1') {
                        $permission[$key] = true;
                    }
                }
            }
            $response = [
                "success" => true,
                "data" => $permissions
            ];
        } else {
            throw new Exception("No data found for the provided role ID");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
