<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $query = "SELECT enquiries.*, 
                            office.name AS office_name, 
                            category_level_one.name AS cat_one_name, 
                            category_level_two.name AS cat_two_name, 
                            category_level_three.name AS cat_three_name, 
                            category_level_four.name AS cat_four_name 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id";

        $params = [];

        if(isset($_GET['quot_status']) && $_GET['quot_status'] == 1){
            $query .= " INNER JOIN quotations ON quotations.enquiry_id = enquiries.id ";
        } 

        // Check if an ID parameter is provided
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $query .= " WHERE enquiries.id = :id";
            $params[':id'] = $id;
        } elseif (isset($_GET['user_id'])) {
            $user_id = $_GET['user_id'];
            $query .= " WHERE enquiries.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = :user_id AND status = 1)";
            $params[':user_id'] = $user_id;
        } else {
            $query .= " WHERE 1=1"; // Adding this to facilitate appending further conditions
        }

        if(isset($_GET['quot_status']) && $_GET['quot_status'] == 2){
            $query .= " AND enquiries.id NOT IN (SELECT enquiry_id FROM quotations) ";
        }

        // Check for date range
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
            $start_date = $_GET['start_date'];
            $end_date = $_GET['end_date'];
            $query .= " AND DATE(created_at) BETWEEN DATE(:start_date) AND DATE(:end_date)";
            $params[':start_date'] = $start_date;
            $params[':end_date'] = $end_date;
        }

        if (isset($_GET['status'])) {
            $status = $_GET['status'];
            $query .= " AND enquiries.status = :status";
            $params[':status'] = $status;
        }

        $query .= " ORDER BY enquiries.created_at DESC";

        // Prepare and execute the statement
        $stmt = $conn->prepare($query);
        $stmt->execute($params);

        // Fetch all records or a single record
        $results = isset($id) ? [$stmt->fetch(PDO::FETCH_ASSOC)] : $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Fetch field mappings with status 1
        $fieldStmt = $conn->prepare("SELECT field_name, title, order_no FROM enquiry_fields WHERE status = 1 ORDER BY order_no");
        $fieldStmt->execute();
        $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

        if ($id) {
            $pStmt = $conn->prepare("SELECT * FROM enquiry_products ep INNER JOIN products p ON ep.product_id = p.id WHERE ep.enquiry_id = :id");
            $pStmt->execute([':id' => $id]);
            $pStmt = $pStmt->fetchAll(PDO::FETCH_ASSOC);
        }



        // Create a mapping of field names to titles
        $fieldMapping = [];
        foreach ($fields as $field) {
            $fieldMapping[$field['field_name']] = [
                'title' => $field['title'],
                'order_no' => $field['order_no']
            ];
        }

        // Define the required IDs
        $requiredIDs = ['office_name', 'cat_one_name', 'cat_two_name', 'cat_three_name', 'cat_four_name', 'status', 'enquiry_status_steps'];

        $responseData = [];
        foreach ($results as $result) {
            $dataWithTitles = [];
            $processedKeys = [];

            foreach ($result as $key => $value) {
                // Include the required IDs explicitly
                if (isset($fieldMapping[$key]) || in_array($key, $requiredIDs)) {
                    $title = isset($fieldMapping[$key]) ? $fieldMapping[$key]['title'] : ucfirst(str_replace('_', ' ', $key));
                    $order_no = isset($fieldMapping[$key]) ? $fieldMapping[$key]['order_no'] : null;

                    $dataWithTitles[] = [
                        "field_name" => $key,
                        "title" => $title,
                        "value" => $value,
                        "order_no" => $order_no // Add order_no to the response
                    ];
                    $processedKeys[] = $key;
                }
            }

            // Ensure all required IDs are included even if they are null
            foreach ($requiredIDs as $requiredID) {
                if (!in_array($requiredID, $processedKeys)) {
                    $dataWithTitles[] = [
                        "field_name" => $requiredID,
                        "title" => ucfirst(str_replace('_', ' ', $requiredID)),
                        "value" => null,
                        "order_no" => null // Assign null if order_no is not applicable
                    ];
                }
            }

            // Sort $dataWithTitles array by order_no
            usort($dataWithTitles, function ($a, $b) {
                return $a['order_no'] <=> $b['order_no'];
            });

            if ($result['id']) {
                $pStmt = $conn->prepare("SELECT * FROM enquiry_products ep INNER JOIN products p ON ep.product_id = p.id WHERE ep.enquiry_id = :id");
                $pStmt->execute([':id' => $result['id']]);
                $pStmt = $pStmt->fetchAll(PDO::FETCH_ASSOC);
            }

            $e_status = $conn->prepare("SELECT enquiry_status_steps FROM enquiries WHERE id = :id");
            $e_status->execute([':id' => $result['id']]);
            $e_res = $e_status->fetchAll(PDO::FETCH_ASSOC);


            $imgStmt = $conn->prepare("SELECT * FROM enquiry_images WHERE enquiry_id = :id");
            $imgStmt->execute([':id' => $result['id']]);
            $imgStmt = $imgStmt->fetchAll(PDO::FETCH_ASSOC);


            $responseData[] = [
                "id" => $result['id'],
                "fields" => $dataWithTitles,
                "products" => $pStmt,
                "status" => $e_res,
                "images" => $imgStmt
            ];
        }

        $response = [
            "success" => true,
            "data" => isset($id) ? $responseData[0] : $responseData
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
